define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.factory('httpInterceptor', function($q, $injector) {
		var interceptor = {};

		interceptor.responseError = function(rejection) {
			var newPromise;
			switch (rejection.status) {
				case 400:
					break;
				case 401:
				case 403:
                    if (rejection.config.url.match(/AssessmentServices\/v.*$/)) {
                        $injector.invoke(['$state', function($state) {
                            $state.go('main.auth.unauthorized', {
                                moduleName: 'Assessment Builder',
                                primaryHeaderTitle: 'Assessment Builder'
                            });
                            return $q.defer().resolve();
                        }]);
                    } else if (rejection.config.url.match(/VarUtilityServices\/v.*$/)) {
                        $injector.invoke(['$state', function($state) {
                            $state.go('main.auth.unauthorized', {
                                moduleName: 'VAR Utility',
                                primaryHeaderTitle: 'VAR Utility'
                            });
                            return $q.defer().resolve();
                        }]);
					} else {
						$injector.invoke(['authenticationService', 'connectionTimeoutService', function (authenticationService, connectionTimeoutService) {
							if (authenticationService.isAuthenticated()) {
								connectionTimeoutService.showSessionEndedMsg();
							}
						}]);
					}
					break;
                case 404:
                    if(rejection.config.url.match(/v[0-9]+\/m[0-9]+\/p[0-9]+\/rest*$/)) {
                        return rejection;
                    }
				default:
					if(rejection.status >= 100){
						newPromise = $injector.invoke(['connectionErrorService', function (connectionErrorService) {
							return connectionErrorService.showServerErrorMsg(rejection);
						}]);
					}
					break;
			}

			return newPromise || $q.reject(rejection);
		};

		return interceptor;
	});

});
